<?php

namespace App\Models;

use CodeIgniter\Model;

class EvaluasiModel extends Model
{
    protected $table = 'evaluasi_kinerja';
    protected $primaryKey = 'id';
    protected $useAutoIncrement = true;
    protected $allowedFields = [
    'id_guru',
    'periode',
    'rpp',
    'foto_kegiatan',
    'dokumen_absensi',
    'dokumen_kedisiplinan', // ✅ Tambahkan ini
    'tema_bulanan',         // ✅ Dan ini juga
    'status',
    'pedagogik', 'profesional', 'sosial', 'kepribadian', 'nilai',
    'indikator1', 'indikator2', 'indikator3',
    'indikator4', 'indikator5',
    'indikator6', 'indikator7',
    'indikator8', 'indikator9',
    'jumlah_tidak_hadir', 'absensi_bulanan',
    'jumlah_tepat_waktu',
    'catatan_kepsek', 'status', 'updated_at',
    'alasan_penolakan',
];

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    /**
     * Ambil semua data evaluasi lengkap dengan nama guru
     */
    public function getAllEvaluasiWithGuru()
    {
        return $this->select('evaluasi_kinerja.*, guru.nama_guru AS nama_guru, evaluasi_kinerja.alasan_penolakan')
                    ->join('users', 'users.id = evaluasi_kinerja.id_guru', 'left')
                    ->join('guru', 'guru.id = users.id_guru', 'left')
                    ->orderBy('evaluasi_kinerja.created_at', 'DESC')
                    ->findAll();
    }
}
