<?php

namespace App\Models;

use CodeIgniter\Model;

class UserModel extends Model
{
    protected $table      = 'users';
    protected $primaryKey = 'id';
    protected $allowedFields = ['username', 'password', 'nama', 'role', 'id_guru'];

    /**
     * Cek login berdasarkan username dan password
     */
    public function checkLogin($username, $password)
    {
        $user = $this->where('username', $username)->first();

        if ($user) {
            if (password_verify($password, $user['password'])) {
                return $user;
            }
        }

        return null;
    }
}
