<?= $this->include('layout/head') ?>
<?= $this->include('layout/sidebar') ?>

<main id="main" class="main">
    <div class="container-fluid p-4">
        <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4">
            <div class="container-fluid d-flex justify-content-between align-items-center">
                <h4 class="m-0 text-primary">Tambah Laporan Kinerja</h4>
                <a href="<?= base_url('evaluasi/evaluasi_guru') ?>" class="btn btn-secondary btn-sm">
                    <i class="fas fa-arrow-left"></i> Kembali
                </a>
            </div>
        </nav>

        <form action="<?= base_url('evaluasi/store') ?>" method="post" enctype="multipart/form-data">
            <?= csrf_field() ?>

            <div class="card shadow mb-4">
                <div class="card-header text-white" style="background-color: #5c8978;">
                    <strong>Form Laporan Kinerja Guru</strong>
                </div>
                <div class="card-body">

                    <!-- Nama Guru (dari session) -->
                    <div class="mb-3">
                        <label for="nama_guru" class="form-label">Nama Guru</label>
                        <input type="text" class="form-control" value="<?= esc($namaGuruLogin) ?>" disabled>
                        <input type="hidden" name="id_guru" value="<?= esc($idGuruLogin) ?>">
                    </div>

                    <!-- Periode -->
                    <div class="mb-3">
                        <label for="periode" class="form-label">Periode Bulan & Tahun</label>
                        <select name="periode" id="periode" class="form-select" required>
                            <option value="">-- Pilih Periode --</option>
                            <?php foreach ($periode as $p): ?>
                                <option value="<?= esc($p['id']) ?>" <?= old('periode') == $p['id'] ? 'selected' : '' ?>>
                                    <?= esc($p['nama_periode']) . ' ' . esc($p['tahun_ajaran']) ?>
                                </option>
                            <?php endforeach ?>
                        </select>
                    </div>

                    <!-- Tambahkan field lainnya jika diperlukan seperti nama_kegiatan, deskripsi, capaian, dll -->

                    <hr>
                    <h6 class="fw-bold">Upload Berkas Pendukung</h6>

                 <!-- Upload RPP -->
                    <div class="mb-3">
                        <label for="rpp" class="form-label">RPP (PDF/DOC)</label>
                        <input type="file" name="rpp" id="rpp" class="form-control" accept=".pdf,.doc,.docx">
                        <div id="rppInfo" class="form-text text-danger d-none">
                            Upload RPP hanya tersedia pada bulan <strong>Januari</strong> dan <strong>Juli</strong>.
                        </div>

                        <!-- Tempat teks RPP terakhir -->
                        <div id="lastRppInfo" class="form-text text-dark mt-1 d-none">
                            📄 RPP terakhir yang diunggah: 
                            <a id="lastRppLink" href="#" target="_blank"></a>
                        </div>
                    </div>

                    <!-- Upload Foto Kegiatan -->
                    <div class="mb-3">
                        <label for="foto_kegiatan" class="form-label">Foto Dokumentasi (JPG/PNG)</label>
                        <input type="file" name="foto_kegiatan" id="foto_kegiatan" class="form-control" accept=".jpg,.jpeg,.png" required>
                    </div>

                    <!-- Upload Dokumen Kehadiran -->
                    <div class="mb-3">
                        <label for="dokumen_absensi" class="form-label">Dokumen Kehadiran (PDF/DOC/Excel/JPG/PNG)</label>
                        <input type="file" name="dokumen_absensi" id="dokumen_absensi" class="form-control" accept=".pdf,.doc,.docx,.xls,.xlsx,.jpg,.jpeg,.png" required>
                    </div>

                    <!-- Upload Dokumen Kedisiplinan -->
                    <div class="mb-3">
                        <label for="dokumen_kedisiplinan" class="form-label">Dokumen Kedisiplinan (JPG/PNG)</label>
                        <input type="file" name="dokumen_kedisiplinan" id="dokumen_kedisiplinan" class="form-control" accept=".jpg,.jpeg,.png" required>
                    </div>

                    <!-- Upload Tema Bulanan -->
                    <div class="mb-3">
                        <label for="tema_bulanan" class="form-label">Tema Bulanan (JPG/PNG)</label>
                        <input type="file" name="tema_bulanan" id="tema_bulanan" class="form-control" accept=".jpg,.jpeg,.png" required>
                    </div>

                    <!-- Tombol Aksi -->
                    <div class="text-end mt-4">
                        <button type="submit" class="btn btn-success btn-sm me-2">
                            <i class="fas fa-upload"></i> Submit Laporan
                        </button>
                        <a href="<?= base_url('evaluasi/evaluasi_guru') ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Batal
                        </a>
                    </div>

                </div>
            </div>
        </form>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const periodeSelect = document.getElementById('periode');
    const rppInput = document.getElementById('rpp');
    const rppInfo = document.getElementById('rppInfo');

    const lastRppInfo = document.getElementById('lastRppInfo');
    const lastRppLink = document.getElementById('lastRppLink');

    const lastRppUrl = <?= $lastRpp ? json_encode(base_url('uploads/rpp/' . $lastRpp)) : 'null' ?>;
    const lastRppName = <?= $lastRpp ? json_encode($lastRpp) : 'null' ?>;

    function updateRppInput() {
        const selected = periodeSelect.options[periodeSelect.selectedIndex];
        if (!selected) return;

        const text = selected.textContent.toLowerCase();
        const isJuliOrJanuari = text.includes('juli') || text.includes('januari');

        if (isJuliOrJanuari) {
            // Bulan Januari / Juli
            rppInput.removeAttribute('disabled');
            rppInput.setAttribute('required', 'required');
            rppInfo.classList.add('d-none');
            lastRppInfo.classList.add('d-none');
        } else {
            // Selain Januari / Juli
            rppInput.value = '';
            rppInput.setAttribute('disabled', 'disabled');
            rppInput.removeAttribute('required');
            rppInfo.classList.remove('d-none');

            if (lastRppUrl && lastRppName) {
                lastRppLink.href = lastRppUrl;
                lastRppLink.textContent = lastRppName;
                lastRppInfo.classList.remove('d-none');
            } else {
                lastRppInfo.classList.add('d-none');
            }
        }
    }

    periodeSelect.addEventListener('change', updateRppInput);
});
</script>

</body>
