<!DOCTYPE html>
<html lang="en">
<head>
    <title>Edit Evaluasi Kinerja</title>
    <?= $this->include('layout/head') ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
</head>

<body>
<?= $this->include('layout/sidebar') ?>

<main id="main" class="main">
    <div class="pagetitle">
        <div class="container mt-4">
            <div class="card shadow">
                <div class="card-header text-white" style="background-color: #5c8978;">
                    <h5 class="mb-0">Edit Evaluasi Kinerja Guru</h5>
                </div>
                <div class="card-body">
                    <form action="<?= base_url('evaluasi/update/' . $evaluasi['id']) ?>" method="post" enctype="multipart/form-data">
                        <?= csrf_field() ?>

                        <div class="row">
                            <!-- Kolom Kiri -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="periode" class="form-label">Periode Bulan & Tahun</label>
                                    <select name="periode" id="periode" class="form-select" required>
                                        <option value="">-- Pilih Periode --</option>
                                        <?php foreach ($periode as $p): ?>
                                            <?php $selected = ($evaluasi['periode'] == $p['id']) ? 'selected' : ''; ?>
                                            <option value="<?= esc($p['id']) ?>" <?= $selected ?>>
                                                <?= esc($p['nama_periode']) . ' - ' . esc($p['tahun_ajaran']) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>

                                <hr>
                                <label class="form-label fw-bold">Ubah Berkas Pendukung (opsional)</label>

                                <div class="mb-2">
                                    <label for="rpp" class="form-label">RPP (PDF/Doc)</label>
                                    <input type="file" name="rpp" id="rpp" class="form-control" accept=".pdf,.doc,.docx">
                                    <?php if (!empty($evaluasi['rpp'])): ?>
                                        <small class="text-muted">File lama: <?= esc($evaluasi['rpp']) ?></small>
                                    <?php endif; ?>
                                </div>

                                <div class="mb-2">
                                    <label for="foto_kegiatan" class="form-label">Foto Dokumentasi (JPG/PNG)</label>
                                    <input type="file" name="foto_kegiatan" id="foto_kegiatan" class="form-control" accept=".jpg,.jpeg,.png">
                                    <?php if (!empty($evaluasi['foto_kegiatan'])): ?>
                                        <div class="mt-2">
                                            <img src="<?= base_url('uploads/foto_kegiatan/' . $evaluasi['foto_kegiatan']) ?>" width="150">
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <div class="mb-2">
                                    <label for="absensi" class="form-label">Dokumen Kehadiran (PDF/DOC/Excel/JPG/PNG)</label>
                                    <input type="file" name="dokumen_absensi" id="absensi" class="form-control" accept=".pdf,.doc,.docx,.xls,.xlsx,.jpg,.jpeg,.png">
                                    <?php if (!empty($evaluasi['dokumen_absensi'])): ?>
                                        <small class="text-muted">File lama: <?= esc($evaluasi['dokumen_absensi']) ?></small>
                                    <?php endif; ?>
                                </div>

                                <div class="mb-2">
                                    <label for="dokumen_kedisiplinan" class="form-label">Dokumen Kedisiplinan (JPG/PNG)</label>
                                    <input type="file" name="dokumen_kedisiplinan" id="dokumen_kedisiplinan" class="form-control" accept=".jpg,.jpeg,.png">
                                    <?php if (!empty($evaluasi['dokumen_kedisiplinan'])): ?>
                                        <div class="mt-2">
                                            <img src="<?= base_url('uploads/kedisiplinan/' . $evaluasi['dokumen_kedisiplinan']) ?>" width="150">
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <div class="mb-2">
                                    <label for="tema_bulanan" class="form-label">Tema Bulanan (JPG/PNG)</label>
                                    <input type="file" name="tema_bulanan" id="tema_bulanan" class="form-control" accept=".jpg,.jpeg,.png">
                                    <?php if (!empty($evaluasi['tema_bulanan'])): ?>
                                        <div class="mt-2">
                                            <img src="<?= base_url('uploads/tema_bulanan/' . $evaluasi['tema_bulanan']) ?>" width="150">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="text-end mt-3">
                            <button type="submit" class="btn btn-primary btn-sm me-2">
                                <i class="fas fa-save"></i> Simpan Perubahan
                            </button>
                            <a href="<?= base_url('evaluasi/evaluasi_guru') ?>" class="btn btn-secondary btn-sm">
                                <i class="fas fa-arrow-left"></i> Batal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
