<!DOCTYPE html>
<html lang="en">
<head>
    <title>Rekapan Evaluasi Guru</title>
    <?= $this->include('layout/head') ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
</head>
<body>
    <?= $this->include('layout/sidebar') ?>
    <main id="main" class="main">
        <!-- Konten Evaluasi untuk Admin -->
        <div class="container-fluid p-4">
            <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4">
                <div class="container-fluid d-flex justify-content-between align-items-center">
                    <h4 class="m-0 text-primary">Rekap Evaluasi Admin</h4>
                    <div>
                        <a href="<?= base_url('dashboard') ?>" class="btn btn-secondary btn-sm">
                            <i class="fa fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
            </nav>

            <!-- Tabel Evaluasi -->
            <div class="card shadow">
                <div class="card-header text-white" style="background-color: #5c8978;">
                    <strong>Data Rekapan Evaluasi</strong>
                </div>
                 <div class="card-body">
                    <div class="mb-3 d-flex justify-content-end">
                        <input type="text" id="searchInput" class="form-control w-25" placeholder="Cari...">
                    </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped text-center" id="evaluasiTable">
                            <thead class="bg-light">
                                <tr>
                                     <th>No</th>
                                    <th>Periode</th>
                                    <th>Nama Guru</th>
                                    <th>Status</th>
                                    <th>Tanggal Pengajuan</th>
                                    <th>rpp</th>
                                    <th>foto</th>
                                    <th>Absensi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $no = 1; foreach ($evaluasi as $e): ?>
                                    <tr>
                                        <td><?= $no++ ?></td>
                                        <td><?= esc($e['periode']) . ' ' . esc($e['tahun_ajaran']) ?></td>
                                         <td><?= esc($e['nama_guru']) ?></td>
                                        <td>
                                            <?php if ($e['status'] === 'Diajukan'): ?>
                                                <span class="badge bg-warning text-dark">Diajukan</span>
                                            <?php elseif ($e['status'] === 'Disetujui'): ?>
                                                <span class="badge bg-primary">Disetujui</span>
                                            <?php elseif ($e['status'] === 'Dinilai'): ?>
                                                <span class="badge bg-success">Dinilai</span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary"><?= esc($e['status']) ?></span>
                                            <?php endif ?>
                                        </td>
                                        <td><?= esc($e['created_at']) ?></td>
                                         <td>
                                            <?php if (!empty($e['rpp'])): ?>
                                                <a href="<?= base_url('uploads/rpp/' . $e['rpp']) ?>" target="_blank" class="btn btn-outline-primary btn-sm">
                                                    <i class="fa fa-eye"></i> Lihat RPP
                                                </a>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif ?>
                                        </td>
                                        <td>
                                            <?php if (!empty($e['foto_kegiatan'])): ?>
                                                <a href="<?= base_url('uploads/foto/' . $e['foto_kegiatan']) ?>" target="_blank">
                                                    <img src="<?= base_url('uploads/foto/' . $e['foto_kegiatan']) ?>" width="60" height="60" style="object-fit: cover; border-radius: 5px;">
                                                </a>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif ?>
                                        </td>
                                        <td>
                                            <?php if (!empty($e['dokumen_absensi'])): ?>
                                                <a href="<?= base_url('uploads/absensi/' . $e['dokumen_absensi']) ?>" target="_blank" class="btn btn-outline-primary btn-sm">
                                                    <i class="fa fa-file"></i> Lihat Absensi
                                                </a>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif ?>
                                        </td>
                                    </tr>
                                <?php endforeach ?>
                            </tbody>
                        </table>
                    </div>
                    <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        const searchInput = document.getElementById('searchInput');
                        const table = document.getElementById('evaluasiTable');
                        searchInput.addEventListener('keyup', function() {
                            const filter = searchInput.value.toLowerCase();
                            const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');
                            for (let i = 0; i < rows.length; i++) {
                                let rowText = rows[i].textContent.toLowerCase();
                                rows[i].style.display = rowText.indexOf(filter) > -1 ? '' : 'none';
                            }
                        });
                    });
                    </script>
                </div>
            </div>
        </div>
    </main>
   </body>
</html>
