<?= $this->include('layout/head') ?>
<?= $this->include('layout/sidebar') ?>

<main id="main" class="main">
<div class="container-fluid p-4">
    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4">
        <div class="container-fluid d-flex justify-content-between align-items-center">
            <h4 class="m-0 text-primary">Data Evaluasi Kinerja</h4>
            <a href="<?= base_url('dashboard') ?>" class="btn btn-secondary btn-sm">
                <i class="fa fa-arrow-left"></i> Kembali
            </a>
        </div>
    </nav>

    <div class="card shadow">
        <div class="card-header text-white" style="background-color: #5c8978;">
            <strong>Data Nilai & Evaluasi</strong>
        </div>
        <div class="card-body">
            <div class="mb-3 d-flex justify-content-end">
                <input type="text" id="searchInput" class="form-control w-25" placeholder="Cari...">
            </div>
            <div class="table-responsive">
                <table class="table table-bordered table-striped text-center" id="evaluasiTable">
                    <thead class="bg-light">
                        <tr>
                            <th>No</th>
                            <th>Nama Guru</th>
                            <th>Periode</th>
                            <th>Status</th>
                            <th>Pengajuan</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1; foreach ($evaluasi as $e): ?>
                            <?php if ($e['status'] === 'Disetujui'): ?>
                                <tr>
                                    <td><?= $no++ ?></td>
                                   <td class="text-start"><?= esc($e['nama_guru']) ?></td>
                                    <td><?= esc($e['periode']) ?> - <?= esc($e['tahun_ajaran']) ?></td>
                                    <td><span class="badge bg-primary"><?= esc($e['status']) ?></span></td>
                                    <td><?= date('d-m-Y', strtotime($e['created_at'])) ?></td>
                                    <td>
                                        <button class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#modalDetail<?= $e['id'] ?>">
                                            <i class="fa fa-eye"></i> Detail Dokumen Pendukung
                                        </button>
                                        <?php
                                            $sudahUploadRpp = !empty($e['rpp']);
                                            $sudahUploadDokumentasi = !empty($e['foto_kegiatan']);
                                            $sudahUploadAbsensi = !empty($e['absensi_bulanan']);

                                            $sudahAdaDokumenPendukung = $sudahUploadRpp || $sudahUploadDokumentasi || $sudahUploadAbsensi;
                                        ?>
                  
                                        <?php
                                        // definisikan logika penilaian sebelum if
                                        $sudahDinilai = !empty($e['nilai']);
                                        ?>

                                        <?php if ($sudahDinilai): ?>
                                            <button class="btn btn-primary btn-sm mb-1" data-bs-toggle="modal" data-bs-target="#modalNilai<?= $e['id'] ?>">
                                                <i class="fa fa-star"></i> Lihat Nilai
                                            </button>
                                            <a href="<?= base_url('evaluasi/cetak/' . $e['id']) ?>" target="_blank" class="btn btn-success btn-sm mb-1">
                                                <i class="fa fa-file-pdf"></i> Cetak PDF
                                            </a>

                                      <!-- Modal Detail Nilai -->
                                        <div class="modal fade" id="modalNilai<?= $e['id'] ?>" tabindex="-1" aria-labelledby="modalNilaiLabel<?= $e['id'] ?>" aria-hidden="true">
                                            <div class="modal-dialog modal-lg modal-dialog-scrollable">
                                                <div class="modal-content">
                                                    <div class="modal-header text-white" style="background-color: #5c8978;">
                                                        <h5 class="modal-title" id="modalNilaiLabel<?= $e['id'] ?>">Detail Penilaian Guru</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
                                                    </div>

                                                    <div class="modal-body">
                                                        <?php
                                                        $db = \Config\Database::connect();
                                                        $guru = $db->table('guru')->where('id', $e['id_guru'])->get()->getRow();
                                                        $nilai_indikator = $db->table('nilai_indikator')->where('id_evaluasi', $e['id'])->get()->getResultArray();

                                                        $nilaiMap = [];
                                                        foreach ($nilai_indikator as $n) {
                                                            $nilaiMap[$n['indikator']] = $n['nilai'];
                                                        }

                                                        $totalNilai = $e['nilai'] ?? 0;
                                                        if ($totalNilai < 70) {
                                                            $predikat = '<span class="badge bg-danger">Kurang</span>';
                                                        } elseif ($totalNilai <= 80) {
                                                            $predikat = '<span class="badge bg-warning text-dark">Cukup</span>';
                                                        } elseif ($totalNilai <= 95) {
                                                            $predikat = '<span class="badge bg-info text-dark">Baik</span>';
                                                        } else {
                                                            $predikat = '<span class="badge bg-success">Baik Sekali</span>';
                                                        }
                                                        ?>

                                                        <p><strong>Nama Guru:</strong> <?= esc($guru->nama_guru ?? '-') ?></p>

                                                        <style>
                                                            .modal .table th, .modal .table td {
                                                                text-align: left !important;
                                                                vertical-align: top;
                                                            }
                                                        </style>

                                                        <div class="table-responsive">
                                                            <table class="table table-bordered small">

                                                                <!-- Pedagogik -->
                                                                <thead class="table-light"><tr><th colspan="2" class="fw-bold">Kompetensi 1: Pedagogik (20%)</th></tr></thead>
                                                                <tbody>
                                                                    <tr><td>A. Kesesuaian Tema Bulanan dengan RPP Semester</td><td><?= $nilaiMap['pedagogik1'] ?? '-' ?></td></tr>
                                                                    <tr><td>B. Penerapan Pendekatan Bermain</td><td><?= $nilaiMap['pedagogik2'] ?? '-' ?></td></tr>
                                                                    <tr><td>C. Penggunaan media pembelajaran yang sesuai usia</td><td><?= $nilaiMap['pedagogik3'] ?? '-' ?></td></tr>
                                                                    <tr><td>D. Observasi perkembangan anak</td><td><?= $nilaiMap['pedagogik4'] ?? '-' ?></td></tr>
                                                                    <tr class="table-success fw-bold"><td>Nilai Pedagogik</td><td><?= number_format($e['pedagogik'], 2) ?>%</td></tr>
                                                                </tbody>

                                                                <!-- Profesional -->
                                                                <thead class="table-light"><tr><th colspan="2" class="fw-bold">Kompetensi 2: Profesional (20%)</th></tr></thead>
                                                                <tbody>
                                                                    <tr><td>A. Penguasaan Materi Pembelajaran</td><td><?= $nilaiMap['profesional1'] ?? '-' ?></td></tr>
                                                                    <tr><td>B. Penggunaan Media Ajar</td><td><?= $nilaiMap['profesional2'] ?? '-' ?></td></tr>
                                                                    <tr><td>C. Pemanfaatan teknologi sederhana dalam pembelajaran</td><td><?= $nilaiMap['profesional3'] ?? '-' ?></td></tr>
                                                                    <tr class="table-success fw-bold"><td>Nilai Profesional</td><td><?= number_format($e['profesional'], 2) ?>%</td></tr>
                                                                </tbody>

                                                                <!-- Kepribadian -->
                                                                <thead class="table-light"><tr><th colspan="2" class="fw-bold">Kompetensi 3: Kepribadian (40%)</th></tr></thead>
                                                                <tbody>
                                                                    <tr><td>A. Keteladanan dan Tanggung Jawab</td><td><?= $nilaiMap['kepribadian1'] ?? '-' ?></td></tr>
                                                                    <tr><td>B. Penampilan guru dalam berpakaian layaknya seorang guru</td><td><?= $nilaiMap['kepribadian2'] ?? '-' ?></td></tr>
                                                                    <tr><td>C. Jumlah kehadiran (absen)</td><td><?= $nilaiMap['kepribadian_hadir'] ?? '-' ?></td></tr>
                                                                    <tr><td>D. Kedisiplinan (tepat waktu)</td><td><?= $nilaiMap['kepribadian_tepat'] ?? '-' ?></td></tr>
                                                                    <tr class="table-success fw-bold"><td>Nilai Kepribadian</td><td><?= number_format($e['kepribadian'], 2) ?>%</td></tr>
                                                                </tbody>

                                                                <!-- Sosial -->
                                                                <thead class="table-light"><tr><th colspan="2" class="fw-bold">Kompetensi 4: Sosial (20%)</th></tr></thead>
                                                                <tbody>
                                                                    <tr><td>A. Komunikasi dengan Orang Tua Siswa</td><td><?= $nilaiMap['sosial1'] ?? '-' ?></td></tr>
                                                                    <tr><td>B. Kerja Sama dengan Rekan/Guru</td><td><?= $nilaiMap['sosial2'] ?? '-' ?></td></tr>
                                                                    <tr><td>C. Partisipasi kegiatan sekolah</td><td><?= $nilaiMap['sosial3'] ?? '-' ?></td></tr>
                                                                    <tr class="table-success fw-bold"><td>Nilai Sosial</td><td><?= number_format($e['sosial'], 2) ?>%</td></tr>
                                                                </tbody>

                                                                <!-- Total -->
                                                                <tfoot class="table-info fw-bold">
                                                                    <tr><td>Total Nilai</td><td><?= number_format($totalNilai, 2) ?>% <?= $predikat ?></td></tr>
                                                                </tfoot>
                                                            </table>
                                                        </div>

                                                        <div class="mt-3">
                                                            <strong>Catatan Kepala Sekolah:</strong>
                                                            <div class="border p-2 bg-light"><?= esc($e['catatan_kepsek'] ?? '-') ?></div>
                                                        </div>
                                                    </div>

                                                    <div class="modal-footer d-flex justify-content-between">
                                                        <a href="<?= base_url('evaluasi/nilai/' . $e['id']) ?>" class="btn btn-warning">
                                                            <i class="fa fa-edit"></i> Edit Nilai
                                                        </a>
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php else: ?>
                                            <a href="<?= base_url('evaluasi/nilai/' . $e['id']) ?>" class="btn btn-success btn-sm mb-1">
                                                <i class="fa fa-pen"></i> Beri Nilai
                                            </a>
                                        <?php endif; ?>

                                        <!-- Modal Detail -->
                                        <div class="modal fade" id="modalDetail<?= $e['id'] ?>" tabindex="-1" aria-hidden="true">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header text-white" style="background-color: #5c8978;">
                                                        <h5 class="modal-title text-start">Detail Evaluasi: <?= esc($e['nama_guru']) ?></h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                    </div>
                                                    <div class="modal-body text-start">

                                                        <!-- Periode -->
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Periode</label>
                                                            <input type="text" class="form-control" readonly value="<?= esc($e['periode']) ?> - <?= esc($e['tahun_ajaran']) ?>">
                                                        </div>

                                                        <!-- Tanggal Pengajuan -->
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Tanggal Pengajuan</label>
                                                            <input type="text" class="form-control" readonly value="<?= date('d-m-Y H:i:s', strtotime($e['created_at'])) ?>">
                                                        </div>

                                                        <!-- Dokumen Terlampir -->
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Dokumen Terlampir</label>
                                                            <div class="row g-3">

                                                               <!-- RPP -->
                                                                <div class="col-md-4">
                                                                    <label class="form-label small mb-1">RPP</label><br>
                                                                    <?php if (!empty($e['rpp_terakhir'])): ?>
                                                                        <a href="<?= base_url('uploads/rpp/' . $e['rpp_terakhir']) ?>" target="_blank" class="btn btn-outline-warning btn-sm w-100">Lihat RPP</a>
                                                                    <?php else: ?>
                                                                        <span class="text-muted">Tidak tersedia</span>
                                                                    <?php endif ?>
                                                                </div>

                                                                <!-- Absensi -->
                                                                <div class="col-md-4">
                                                                    <label class="form-label small mb-1">Absensi</label><br>
                                                                    <?= !empty($e['dokumen_absensi']) 
                                                                        ? '<a href="'.base_url('uploads/absensi/'.$e['dokumen_absensi']).'" target="_blank" class="btn btn-outline-primary btn-sm w-100">Lihat Absensi</a>' 
                                                                        : '<span class="text-muted">Tidak tersedia</span>' ?>
                                                                </div>

                                                                <!-- Foto Kegiatan -->
                                                                <div class="col-md-4">
                                                                    <label class="form-label small mb-1">Foto Kegiatan</label><br>
                                                                    <?= !empty($e['foto_kegiatan']) 
                                                                        ? '<a href="'.base_url('uploads/foto/'.$e['foto_kegiatan']).'" target="_blank" class="btn btn-outline-primary btn-sm w-100">Lihat Foto</a>' 
                                                                        : '<span class="text-muted">Tidak tersedia</span>' ?>
                                                                </div>

                                                                <!-- Kedisiplinan -->
                                                                <div class="col-md-4">
                                                                    <label class="form-label small mb-1">Dokumen Kedisiplinan</label><br>
                                                                    <?= !empty($e['dokumen_kedisiplinan']) 
                                                                        ? '<a href="'.base_url('uploads/kedisiplinan/'.$e['dokumen_kedisiplinan']).'" target="_blank" class="btn btn-outline-primary btn-sm w-100">Lihat Kedisiplinan</a>' 
                                                                        : '<span class="text-muted">Tidak tersedia</span>' ?>
                                                                </div>

                                                                <!-- Tema Bulanan -->
                                                                <div class="col-md-4">
                                                                    <label class="form-label small mb-1">Tema Bulanan</label><br>
                                                                    <?= !empty($e['tema_bulanan']) 
                                                                        ? '<a href="'.base_url('uploads/tema/'.$e['tema_bulanan']).'" target="_blank" class="btn btn-outline-primary btn-sm w-100">Lihat Tema</a>' 
                                                                        : '<span class="text-muted">Tidak tersedia</span>' ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="modal-footer justify-content-end">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </td>
                                </tr>
                            <?php endif ?>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const searchInput = document.getElementById('searchInput');
    const rows = document.querySelectorAll('#evaluasiTable tbody tr');
    searchInput.addEventListener('keyup', function () {
        const value = this.value.toLowerCase();
        rows.forEach(row => {
            const match = row.textContent.toLowerCase().includes(value);
            row.style.display = match ? '' : 'none';
        });
    });
});
</script>
</main>
