<?= $this->include('layout/head') ?>
<?= $this->include('layout/sidebar') ?>
<main id="main" class="main">
    <div class="pagetitle">
        <div class="container mt-4">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="card shadow-sm">
                        <div class="card-header text-white" style="background-color: #5c8978;">
                            <h6 class="mb-0">Form Penilaian Evaluasi Kinerja Guru</h6>
                        </div>
                        <div class="card-body mt-3">
                            <div class="row">
                                <!-- Biodata Guru -->
                                <div class="col-md-5">
                                    <div class="card border shadow-sm" style="background-color: #f9f9f9; border-radius: 10px;">
                                        <div class="card-body px-4 py-3">
                                            <h6 class="text-primary fw-bold mb-3">
                                                <i class="fas fa-user-circle me-2"></i> Profil
                                            </h6>
                                            <table class="table table-borderless table-sm mb-0">
                                                <tbody>
                                                    <tr>
                                                        <td class="text-muted small" width="45%">NIP</td>
                                                        <td class="text-muted small">: <?= esc($guru['nip'] ?? '-') ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="text-muted small">Nama</td>
                                                        <td class="text-muted small">: <?= esc($guru['nama_guru'] ?? '-') ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="text-muted small">Pendidikan</td>
                                                        <td class="text-muted small">: <?= esc($guru['pendidikan'] ?? '-') ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="text-muted small">Jabatan</td>
                                                        <td class="text-muted small">: <?= esc($guru['jabatan'] ?? '-') ?></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
<hr class="my-2">
<div class="px-3 pb-3">
    <p class="fw-bold small mb-1">📎 Dokumen Pendukung:</p>

    <?php if (!empty($evaluasi['rpp'])): ?>
        <a href="<?= base_url('uploads/rpp/' . $evaluasi['rpp']) ?>" target="_blank" class="btn btn-outline-primary btn-sm w-100 mb-1">
            📄 Lihat RPP
        </a>
    <?php endif; ?>

    <?php if (!empty($evaluasi['foto_kegiatan'])): ?>
        <a href="<?= base_url('uploads/foto_kegiatan/' . $evaluasi['foto_kegiatan']) ?>" target="_blank" class="btn btn-outline-primary btn-sm w-100 mb-1">
            🖼️ Lihat Dokumentasi
        </a>
    <?php endif; ?>

    <?php if (!empty($evaluasi['dokumen_absensi'])): ?>
        <a href="<?= base_url('uploads/absensi/' . $evaluasi['dokumen_absensi']) ?>" target="_blank" class="btn btn-outline-primary btn-sm w-100 mb-1">
            📊 Lihat Absensi
        </a>
    <?php endif; ?>

    <?php if (!empty($evaluasi['dokumen_kedisiplinan'])): ?>
        <a href="<?= base_url('uploads/kedisiplinan/' . $evaluasi['dokumen_kedisiplinan']) ?>" target="_blank" class="btn btn-outline-primary btn-sm w-100 mb-1">
            ⏰ Lihat Kedisiplinan
        </a>
    <?php endif; ?>

    <?php if (!empty($evaluasi['tema_bulanan'])): ?>
        <a href="<?= base_url('uploads/tema_bulanan/' . $evaluasi['tema_bulanan']) ?>" target="_blank" class="btn btn-outline-primary btn-sm w-100 mb-1">
            📘 Lihat Tema Bulanan
        </a>
    <?php endif; ?>
</div>
                                    </div>
                                </div>

                                <!-- Form Penilaian -->
                                <div class="col-md-7 mt-4 mt-md-0">
                             <form action="<?= base_url('evaluasi/simpanNilai') ?>" method="post">
                                   <input type="hidden" name="id" value="<?= $evaluasi['id'] ?>">


                                    <!-- Kompetensi 1: Pedagogik -->
                                    <div class="card border mb-3 shadow-sm">
                                        <div class="card-header bg-light fw-bold small">Kompetensi 1: Pedagogik (20%)</div>
                                        <div class="card-body">
                                            <div class="mb-2">
                                                <label class="form-label small">A. Kesesuaian Tema Bulanan dengan RPP Semester</label>
                                                <select name="indikator[pedagogik1]" class="form-select form-select-sm indikator" required>
                                                    <option value="">-- Pilih --</option>
                                                    <option value="5">Selalu sesuai</option>
                                                    <option value="3">Kadang sesuai</option>
                                                    <option value="1">Tidak sesuai</option>
                                                </select>
                                            </div>
                                            <div class="mb-2">
                                                <label class="form-label small">B. Penerapan Pendekatan Bermain</label>
                                                <select name="indikator[pedagogik2]" class="form-select form-select-sm indikator" required>
                                                    <option value="">-- Pilih --</option>
                                                    <option value="5">Sangat baik</option>
                                                    <option value="3">Cukup baik</option>
                                                    <option value="1">Kurang</option>
                                                </select>
                                            </div>
                                            <div class="mb-2">
                                                <label class="form-label small">C. Penggunaan media pembelajaran yang sesuai usia</label>
                                                <select name="indikator[pedagogik3]" class="form-select form-select-sm indikator" required>
                                                    <option value="">-- Pilih --</option>
                                                    <option value="5">Sangat Sesuai & Menarik</option>
                                                    <option value="3">Cukup Sesuai</option>
                                                    <option value="1">Kurang Sesuai</option>
                                                </select>
                                            </div>
                                            <div class="mb-2">
                                                <label class="form-label small">D. Observasi perkembangan anak</label>
                                                <select name="indikator[pedagogik4]" class="form-select form-select-sm indikator" required>
                                                    <option value="">-- Pilih --</option>
                                                    <option value="5">Rutin dan terstruktur</option>
                                                    <option value="3">Kadang dilakukan</option>
                                                    <option value="1">Tidak dilakukan</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Kompetensi 2: Profesional -->
                                    <div class="card border mb-3 shadow-sm">
                                        <div class="card-header bg-light fw-bold small">Kompetensi 2: Profesional (20%)</div>
                                        <div class="card-body">
                                            <div class="mb-2">
                                                <label class="form-label small">A. Penguasaan Materi Pembelajaran</label>
                                                <select name="indikator[profesional1]" class="form-select form-select-sm indikator" required>
                                                    <option value="">-- Pilih --</option>
                                                    <option value="5">Menguasai seluruh materi</option>
                                                    <option value="3">Cukup menguasai</option>
                                                    <option value="1">Kurang menguasai</option>
                                                </select>
                                            </div>
                                            <div class="mb-2">
                                                <label class="form-label small">B. Penggunaan Media Ajar</label>
                                                <select name="indikator[profesional2]" class="form-select form-select-sm indikator" required>
                                                    <option value="">-- Pilih --</option>
                                                    <option value="5">Sangat sesuai dan menarik</option>
                                                    <option value="3">Cukup sesuai</option>
                                                    <option value="1">Tidak sesuai</option>
                                                </select>
                                            </div>
                                            <div class="mb-2">
                                                <label class="form-label small">C. Pemanfaatan teknologi sederhana dalam pembelajaran</label>
                                                <select name="indikator[profesional3]" class="form-select form-select-sm indikator" required>
                                                    <option value="">-- Pilih --</option>
                                                    <option value="5">Aktif & efektif</option>
                                                    <option value="3">Cukup digunakan</option>
                                                    <option value="1">Tidak digunakan</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Kompetensi 3: Kepribadian -->
                                    <div class="card border mb-3 shadow-sm">
                                        <div class="card-header bg-light fw-bold small">Kompetensi 3: Kepribadian (40%)</div>
                                        <div class="card-body">
                                            <div class="mb-2">
                                                <label class="form-label small">A. Jumlah Hari Tidak Masuk (dari 20 hari kerja)</label>
                                                <input type="number" name="tidak_hadir" id="tidak_hadir" class="form-control form-control-sm" min="0" max="31" required>
                                            </div>
                                            <div class="mb-2">
                                                <label class="form-label small">B. Jumlah Hari Datang Tepat Waktu (dari 20 hari kerja)</label>
                                                <input type="number" name="tepat_waktu" id="tepat_waktu" class="form-control form-control-sm" min="0" max="31" required>
                                            </div>
                                            <div class="mb-2">
                                                <label class="form-label small">C. Keteladanan dan Tanggung Jawab</label>
                                                <select name="indikator[kepribadian1]" class="form-select form-select-sm indikator" required>
                                                    <option value="">-- Pilih --</option>
                                                    <option value="5">Sangat disiplin dan konsisten</option>
                                                    <option value="3">Cukup baik</option>
                                                    <option value="1">Kurang menjadi teladan</option>
                                                </select>
                                            </div>
                                            <div class="mb-2">
                                                <label class="form-label small">D. Penampilan guru Dalam Berpakaian Layaknya Seorang Guru</label>
                                                <select name="indikator[kepribadian2]" class="form-select form-select-sm indikator" required>
                                                    <option value="">-- Pilih --</option>
                                                    <option value="5">Sangat Rapi & Sopan</option>
                                                    <option value="3">Cukup Rapi</option>
                                                    <option value="1">Kurang Rapi</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Kompetensi 4: Sosial -->
                                    <div class="card border mb-3 shadow-sm">
                                        <div class="card-header bg-light fw-bold small">Kompetensi 4: Sosial (20%)</div>
                                        <div class="card-body">
                                            <div class="mb-2">
                                                <label class="form-label small">A. Komunikasi dengan Orang Tua Siswa</label>
                                                <select name="indikator[sosial1]" class="form-select form-select-sm indikator" required>
                                                    <option value="">-- Pilih --</option>
                                                    <option value="5">Terjalin sangat baik</option>
                                                    <option value="3">Cukup baik</option>
                                                    <option value="1">Kurang</option>
                                                </select>
                                            </div>
                                            <div class="mb-2">
                                                <label class="form-label small">B. Kerja Sama dengan Rekan/Guru</label>
                                                <select name="indikator[sosial2]" class="form-select form-select-sm indikator" required>
                                                    <option value="">-- Pilih --</option>
                                                    <option value="5">Aktif & kolaboratif</option>
                                                    <option value="3">Cukup baik</option>
                                                    <option value="1">Kurang aktif</option>
                                                </select>
                                            </div>
                                            <div class="mb-2">
                                                <label>3. Partisipasi kegiatan sekolah</label>
                                                <select name="indikator[sosial3]" class="form-select form-select-sm indikator" required>
                                                    <option value="">-- Pilih --</option>
                                                    <option value="5">Aktif & berperan</option>
                                                    <option value="3">Cukup aktif</option>
                                                    <option value="1">Jarang ikut</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Hasil -->
                                    <div class="mb-2 small">
                                        <strong>Total Nilai: <span id="totalNilai">0</span>%</strong><br>
                                        Kategori: <strong><span id="kategoriNilai">-</span></strong>
                                    </div>

                                    <div class="mb-2">
                                        <label class="form-label small">Catatan Evaluasi (wajib jika nilai < 75%)</label>
                                        <textarea name="catatan" class="form-control form-control-sm" id="catatanEvaluasi" rows="2"></textarea>
                                    </div>

                                    <div class="d-flex justify-content-start mt-3 gap-2">
                                        <button type="submit" class="btn btn-success btn-sm">
                                            <i class="fas fa-save"></i> Simpan Nilai
                                        </button>
                                        <a href="<?= base_url('evaluasi/evaluasi_kinerja') ?>" class="btn btn-secondary btn-sm">
                                            <i class="fas fa-arrow-left"></i> Batal
                                        </a>
                                    </div>
                                </form>

                                </div> <!-- /form -->
                            </div> <!-- /row -->
                        </div> <!-- /card-body -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    function hitungTotal() {
        const totalHari = 20;

        const tidakHadir = parseInt(document.getElementById('tidak_hadir').value) || 0;
        const tepatWaktu = parseInt(document.getElementById('tepat_waktu').value) || 0;

        const hadir = totalHari - tidakHadir;
        const persenHadir = (hadir / totalHari) * 100;
        let skorHadir = persenHadir >= 95 ? 5 : persenHadir >= 85 ? 4 : persenHadir >= 75 ? 3 : persenHadir >= 60 ? 2 : 1;

        const persenTepat = (tepatWaktu / totalHari) * 100;
        let skorDisiplin = persenTepat >= 95 ? 5 : persenTepat >= 85 ? 4 : persenTepat >= 75 ? 3 : persenTepat >= 60 ? 2 : 1;

        const indikator = Array.from(document.querySelectorAll('.indikator')).map(i => parseInt(i.value) || 0);

        if (indikator.length < 7) {
            console.warn("Jumlah indikator kurang dari 7");
            return;
        }

        const pedagogik = (indikator[0] + indikator[1] + indikator[2] + indikator[3]) / 4;
        const profesional = (indikator[4] + indikator[5] + indikator[6]) / 3;
        const kepribadian = (indikator[7] + indikator[8] + skorHadir + skorDisiplin) / 4;
        const sosial = (indikator[9] + indikator[10] + indikator[11]) / 3;

        const total = (
            (pedagogik / 5) * 20 +
            (profesional / 5) * 20 +
            (kepribadian / 5) * 40 +
            (sosial / 5) * 20
        );

        document.getElementById('totalNilai').innerText = Math.round(total);

        let kategori = '-';
        if (total >= 90) kategori = 'Baik Sekali';
        else if (total >= 80) kategori = 'Baik';
        else if (total >= 70) kategori = 'Cukup';
        else if (total >= 60) kategori = 'Kurang';
        else kategori = 'Sangat Kurang';

        document.getElementById('kategoriNilai').innerText = kategori;

        const catatan = document.getElementById('catatanEvaluasi');
        if (total < 75) {
            catatan.setAttribute('required', 'required');
        } else {
            catatan.removeAttribute('required');
        }
    }

    document.querySelectorAll('.indikator, #tidak_hadir, #tepat_waktu').forEach(el => {
        el.addEventListener('input', hitungTotal);
    });
</script>

