<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Detail Penilaian Guru</title>
    <style>
    body {
        font-family: Arial, sans-serif;
        font-size: 11pt;
        margin: 30px;
        color: #000;
    }

    .header {
        display: flex;
        align-items: center;
        margin-bottom: 15px;
    }

    .logo {
        width: 100px;
        height: 100px;
        margin-right: 15px;
    }

    .info {
        margin-bottom: 20px;
    }

    .info p {
        margin: 3px 0;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 15px;
        font-size: 10pt;
    }

    th, td {
        border: 1px solid #333;
        padding: 6px 8px;
        text-align: left;
    }

    .table-title {
        background-color: #e0e0e0;
        font-weight: bold;
    }

    .bobot-row {
        background-color: #f2f2f2;
        font-weight: bold;
    }

    .total {
        background-color: #dceaf5;
        font-weight: bold;
    }

    .catatan {
        margin-top: 20px;
        font-size: 10pt;
    }

    .catatan-box {
        border: 1px solid #ccc;
        padding: 10px;
        background-color: #f8f8f8;
    }

    .ttd {
        margin-top: 50px;
        text-align: right;
        font-size: 10pt;
    }

    .ttd .ttd-name {
        margin-top: 60px;
        font-weight: bold;
        text-decoration: underline;
    }
    </style>
</head>
<body>
    <?php
        $path = FCPATH . 'assets/logo.jpg';
        $type = pathinfo($path, PATHINFO_EXTENSION);
        $data = file_get_contents($path);
        $base64Logo = 'data:image/' . $type . ';base64,' . base64_encode($data);
    ?>

    <!-- KOP SURAT -->
    <div style="position: relative; width: 100%; margin-bottom: 10px;">
        <div style="position: absolute; top: 0; left: 0;">
            <img src="<?= $base64Logo ?>" style="width: 100px; height: 100px;">
        </div>

        <div style="text-align: center;">
            <div style="font-size: 15pt; font-weight: bold;">HASIL PENILAIAN EVALUASI KINERJA GURU</div>
            <div style="font-size: 13pt; font-weight: bold;">YAYASAN AL-HUSNA</div>
            <div style="font-size: 9pt; line-height: 1.5;">
                Jl. Abduk Karim 13 Kaplingan Sugihwaras Mojokrapak, Kecamatan Tembelang,<br>
                Kabupaten Jombang, Jawa Timur<br>
                Telepon: 085731432525 / 0857063000991
            </div>
        </div>
    </div>

    <hr style="border: 1.5px solid black; margin-top: 10px; margin-bottom: 25px;">

    <!-- INFO -->
    <div class="info">
        <p><strong>Nama Guru:</strong> <?= esc($guru->nama_guru ?? '-') ?></p>
        <p><strong>Tanggal Penilaian:</strong> <?= date('d F Y') ?></p>
    </div>

    <?php
    // Pastikan predikat tidak error jika belum diset
    $predikat = $predikat ?? '';
    ?>
    <!-- TABEL PENILAIAN -->
    <table>
        <tr class="table-title"><th colspan="3">REKAP NILAI PENILAIAN KINERJA GURU</th></tr>

        <!-- PEDAGOGIK -->
        <tr class="table-title"><th colspan="3">Kompetensi 1: Pedagogik (20%)</th></tr>
        <tr><td>A.</td><td>Kesesuaian Tema Bulanan dengan RPP Semester</td><td><?= $nilaiMap['pedagogik1'] ?? '-' ?></td></tr>
        <tr><td>B.</td><td>Penerapan Pendekatan Bermain</td><td><?= $nilaiMap['pedagogik2'] ?? '-' ?></td></tr>
        <tr><td>C.</td><td>Penggunaan media pembelajaran yang sesuai usia</td><td><?= $nilaiMap['pedagogik3'] ?? '-' ?></td></tr>
        <tr><td>D.</td><td>Observasi perkembangan anak</td><td><?= $nilaiMap['pedagogik4'] ?? '-' ?></td></tr>
        <tr class="bobot-row"><td colspan="2">Nilai Pedagogik</td><td><?= number_format($e->pedagogik, 2) ?>%</td></tr>

        <!-- PROFESIONAL -->
        <tr class="table-title"><th colspan="3">Kompetensi 2: Profesional (20%)</th></tr>
        <tr><td>A.</td><td>Penguasaan Materi Pembelajaran</td><td><?= $nilaiMap['profesional1'] ?? '-' ?></td></tr>
        <tr><td>B.</td><td>Penggunaan Media Ajar</td><td><?= $nilaiMap['profesional2'] ?? '-' ?></td></tr>
        <tr><td>C.</td><td>Pemanfaatan teknologi sederhana dalam pembelajaran</td><td><?= $nilaiMap['profesional3'] ?? '-' ?></td></tr>
        <tr class="bobot-row"><td colspan="2">Nilai Profesional</td><td><?= number_format($e->profesional, 2) ?>%</td></tr>

        <!-- KEPRIBADIAN -->
        <tr class="table-title"><th colspan="3">Kompetensi 3: Kepribadian (40%)</th></tr>
        <tr><td>A.</td><td>Skor Kehadiran (berdasarkan absensi)</td><td><?= $nilaiMap['kepribadian_hadir'] ?? '-' ?></td></tr>
        <tr><td>B.</td><td>Skor Kedisiplinan (tepat waktu)</td><td><?= $nilaiMap['kepribadian_tepat'] ?? '-' ?></td></tr>
        <tr><td>C.</td><td>Keteladanan dan Tanggung Jawab</td><td><?= $nilaiMap['kepribadian1'] ?? '-' ?></td></tr>
        <tr><td>D.</td><td>Penampilan guru Dalam Berpakaian Layaknya Seorang Guru</td><td><?= $nilaiMap['kepribadian2'] ?? '-' ?></td></tr>
        <tr class="bobot-row"><td colspan="2">Nilai Kepribadian</td><td><?= number_format($e->kepribadian, 2) ?>%</td></tr>

        <!-- SOSIAL -->
        <tr class="table-title"><th colspan="3">Kompetensi 4: Sosial (20%)</th></tr>
        <tr><td>A.</td><td>Komunikasi dengan Orang Tua Siswa</td><td><?= $nilaiMap['sosial1'] ?? '-' ?></td></tr>
        <tr><td>B.</td><td>Kerja Sama dengan Rekan/Guru</td><td><?= $nilaiMap['sosial2'] ?? '-' ?></td></tr>
        <tr><td>C.</td><td>Partisipasi kegiatan sekolah</td><td><?= $nilaiMap['sosial3'] ?? '-' ?></td></tr>
        <tr class="bobot-row"><td colspan="2">Nilai Sosial</td><td><?= number_format($e->sosial, 2) ?>%</td></tr>

        <!-- TOTAL -->
        <tr class="total"><td colspan="2">Total Nilai</td><td><?= number_format($e->nilai, 2) ?>% (<?= $predikat ?>)</td></tr>
    </table>

    <!-- CATATAN -->
    <div class="catatan">
        <p><strong>Catatan Kepala Sekolah:</strong></p>
        <div class="catatan-box"><?= esc($e->catatan_kepsek ?? '-') ?></div>
    </div>

    <!-- TANDA TANGAN -->
    <div class="ttd">
        <p>Mengetahui,</p>
        <p>Kepala Sekolah</p>
        <p class="ttd-name">............................................</p>
    </div>
    </body>
</html>
