<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Laporan Data Guru</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            margin: 20px;
        }

        h2 {
            text-align: center;
            margin-bottom: 0;
        }

        .line-title {
            border: 0;
            border-top: 2px solid #000;
            margin: 5px 0 15px;
        }

        .info {
            text-align: right;
            font-size: 10px;
            margin-bottom: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 10px;
        }

        table th, table td {
            border: 1px solid #000;
            padding: 6px 4px;
            text-align: center;
        }

        thead {
            background-color: #f0f0f0;
        }
    </style>
</head>
<body>

    <h2>LAPORAN DATA GURU</h2>
    <hr class="line-title">
    <div class="info">
        Dicetak pada: <?= date('d-m-Y') ?>
    </div>

    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Kode Guru</th>
                <th>Nama Guru</th>
                <th>NIP</th>
                <th>Tempat Lahir</th>
                <th>Tanggal Lahir</th>
                <th>JK</th>
                <th>Status</th>
                <th>Agama</th>
                <th>Jabatan</th>
                <th>Pendidikan</th>
            </tr>
        </thead>
        <tbody>
            <?php $no = 1; foreach ($guru as $g): ?>
            <tr>
                <td><?= $no++ ?></td>
                <td><?= esc($g['kode_guru']) ?></td>
                <td><?= esc($g['nama_guru']) ?></td>
                <td><?= esc($g['nip']) ?></td>
                <td><?= esc($g['tempat_lahir']) ?></td>
                <td><?= date('d-m-Y', strtotime($g['tanggal_lahir'])) ?></td>
                <td><?= esc($g['jenis_kelamin']) ?></td>
                <td><?= esc($g['status']) ?></td>
                <td><?= esc($g['agama']) ?></td>
                <td><?= esc($g['jabatan']) ?></td>
                <td><?= esc($g['pendidikan']) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

</body>
</html>
