<!DOCTYPE html>
<html lang="en">

<head>
    <?= $this->include('layout/head') ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
</head>

<body>
<?= $this->include('layout/sidebar') ?>

<main id="main" class="main">
    <div class="pagetitle">
        <!-- Main Content -->
        <div class="container-fluid p-4">

            <!-- Topbar -->
            <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4">
                <div class="container-fluid d-flex justify-content-between align-items-center">
                    <h4 class="m-0 text-primary">Manajemen Data Guru</h4>
                    <div>
                    <?php
                        $role = session()->get('login')['role'];
                        ?>

                        <?php if ($role === 'admin'): ?>
                            <a href="<?= base_url('guru/create') ?>" class="btn btn-success btn-sm me-2">
                                <i class="fa fa-plus"></i> Tambah
                            </a>
                        <?php endif; ?>

                        <?php if ($role === 'admin' || $role === 'kepsek'): ?>
                            <a href="<?= base_url('guru/cetak_pdf') ?>" target="_blank" class="btn btn-danger btn-sm me-2">
                                <i class="fa fa-file-pdf"></i> Cetak PDF
                            </a>
                        <?php endif; ?>

                        <a href="<?= base_url('dashboard') ?>" class="btn btn-secondary btn-sm">
                            <i class="fa fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
            </nav>

            <!-- Flash Message (opsional) -->
            <?php if (session()->getFlashdata('success')) : ?>
                <div class="alert alert-success">
                    <?= session()->getFlashdata('success') ?>
                </div>
            <?php endif; ?>

            <!-- Card Data Guru -->
            <div class="card shadow">
                <div class="card-header" style="background-color: #5c8978;" >
                    <strong>Data Guru</strong>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped text-center">
                            <thead class="bg-light">
                                <tr>
                                    <th>No</th>
                                    <th>Kode Guru</th>
                                    <th>Nama Guru</th>
                                    <th>NIP</th>
                                    <th>Tempat Lahir</th>
                                    <th>Tanggal Lahir</th>
                                    <th>JK</th>
                                    <th>Status</th>
                                    <th>Agama</th>
                                    <th>Jabatan</th>
                                    <th>Pendidikan</th>
                                    <?php if (session()->get('login')['role'] === 'admin'): ?>
                                    <th>Aksi</th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $no = 1; foreach ($guru as $g): ?>
                                <tr>
                                    <td><?= $no++ ?></td>
                                    <td><?= esc($g['kode_guru']) ?></td>
                                    <td class="text-start"><?= esc($g['nama_guru']) ?></td>
                                    <td><?= esc($g['nip']) ?></td>
                                    <td><?= esc($g['tempat_lahir']) ?></td>
                                    <td><?= esc($g['tanggal_lahir']) ?></td>
                                    <td><?= esc($g['jenis_kelamin']) ?></td>
                                    <td><?= esc($g['status']) ?></td>
                                    <td><?= esc($g['agama']) ?></td>
                                    <td><?= esc($g['jabatan']) ?></td>
                                    <td><?= esc($g['pendidikan']) ?></td>
                                     <?php if (session()->get('login')['role'] === 'admin'): ?>
                                    <td>
                                        <a href="<?= base_url('guru/edit/' . $g['id']) ?>" class="btn btn-warning btn-sm me-1"><i class="fa fa-edit"></i></a>
                                        <a href="<?= base_url('guru/delete/' . $g['id']) ?>" onclick="return confirm('Yakin ingin menghapus?')" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a>
                                    </td>
                                     <?php endif; ?>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</main>
</body>

</html>
