<!DOCTYPE html>
<html lang="en">
<head>

<meta charset="utf-8">
<meta content="width=device-width, initial-scale=1.0" name="viewport">
<title>SIKINERJA AL-HUSNA</title>
<meta content="" name="description">
<meta content="" name="keywords">

<!-- Vendor CSS Files -->
<link href="<?= base_url('assets/vendor/bootstrap/css/bootstrap.min.css') ?>" rel="stylesheet">
<link href="<?= base_url('assets/vendor/bootstrap-icons/bootstrap-icons.css') ?>" rel="stylesheet">
<link href="<?= base_url('assets/vendor/boxicons/css/boxicons.min.css') ?>" rel="stylesheet">

<!-- Template Main CSS File -->
<link href="<?= base_url('assets/css/style.css') ?>" rel="stylesheet">

</head>
<body>
<header id="header" class="header fixed-top d-flex align-items-center justify-content-between px-3">

  <!-- Logo dan Toggle -->
  <div class="d-flex align-items-center">
    <div class="logo d-flex align-items-center">
      <img src="<?= base_url('uploads/logo.jpg') ?>" alt="" style="height: 40px;">
      <span class="d-none d-lg-block ms-2">SIKINERJA AL-HUSNA</span>
    </div>
    <i class="bi bi-list toggle-sidebar-btn" style="font-size: 1.5rem; cursor: pointer;"></i>

  </div>

  <!-- Navigasi kanan -->
  <nav class="header-nav d-flex align-items-center">
    <ul class="d-flex align-items-center mb-0">

      <!-- Tanggal & Jam -->
      <li class="nav-item pe-3 d-flex align-items-center">
        <div id="datetime" class="text-dark fw-bold small"></div>
      </li>

      <!-- Profile -->
     <?php 
    $login = session()->get('login');
    $nama = $login['nama'] ?? 'Akun';
    $role = ucfirst($login['role'] ?? '');

    // Cek apakah user punya foto, dan file-nya ada di direktori uploads/photos/
    if (!empty($login['photo']) && file_exists(FCPATH . 'uploads/photos/' . $login['photo'])) {
        $photoPath = base_url('uploads/photos/' . $login['photo']);
    } else {
        $photoPath = base_url('assets/img/default-profile.png'); // default foto
    }
    ?>

    <li class="nav-item dropdown pe-3">
      <a class="nav-link nav-profile d-flex align-items-center pe-0" href="#" data-bs-toggle="dropdown">
        <img src="<?= $photoPath ?>" alt="Profile" class="rounded-circle" style="width: 40px; height: 40px; object-fit: cover;">
        <span class="d-none d-md-block dropdown-toggle ps-2"><?= esc($nama) ?></span>
      </a>
      <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
        <li class="dropdown-header">
          <h6><?= esc($nama) ?></h6>
          <span><?= esc($role) ?></span>
        </li>

          <li><hr class="dropdown-divider"></li>
          <li>
            <a class="dropdown-item d-flex align-items-center" href="<?= base_url('profile') ?>">
              <i class="bi bi-person"></i><span>My Profile</span>
            </a>
          </li>
          <li><hr class="dropdown-divider"></li>
          <li>
            <a class="dropdown-item d-flex align-items-center" href="<?= base_url('logout') ?>">
              <i class="bi bi-box-arrow-right"></i><span>Sign Out</span>
            </a>
          </li>
        </ul>
      </li>
    </ul>
  </nav>
</header>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
  // Sidebar toggle button
  document.addEventListener("DOMContentLoaded", function () {
      document.querySelector(".toggle-sidebar-btn").addEventListener("click", function () {
          document.body.classList.toggle("toggle-sidebar");
      });
  });

  // Jam & Tanggal berjalan
  function updateDateTime() {
      const now = new Date();
      const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
      const tanggal = now.toLocaleDateString('id-ID', options);
      const jam = now.toLocaleTimeString('id-ID');

      document.getElementById('datetime').textContent = `${tanggal}, ${jam}`;
  }

  setInterval(updateDateTime, 1000);
  updateDateTime();
</script>

</body>
</html>
