<!DOCTYPE html>
<html lang="en">

<head>
    <?= $this->include('layout/head') ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
</head>

<body>
<?= $this->include('layout/sidebar') ?>

<main id="main" class="main">
    <div class="pagetitle">
        <div class="container mt-4">
            <div class="card shadow">
                <div class="card-header text-white" style="background-color: #5c8978;">
                    <h5 class="mb-0">Form Edit Periode</h5>
                </div>
                <br>
                <div class="card-body">
                    <form action="<?= base_url('periode/update/' . $periode['id']) ?>" method="post">
                        <div class="row">
                            <!-- Kolom Kiri -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Nama Periode</label>
                                    <input type="text" name="nama_periode" class="form-control" value="<?= esc($periode['nama_periode']) ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Tahun Ajaran</label>
                                    <select name="tahun_ajaran" class="form-select" required>
                                        <option value="">Pilih Tahun Ajaran</option>
                                        <?php
                                            $currentYear = date('Y');
                                            for ($i = $currentYear; $i >= $currentYear - 5; $i--) {
                                                $nextYear = $i + 1;
                                                $tahun = "{$i}/{$nextYear}";
                                                $selected = ($periode['tahun_ajaran'] == $tahun) ? 'selected' : '';
                                                echo "<option value=\"{$tahun}\" {$selected}>{$tahun}</option>";
                                            }
                                        ?>
                                    </select>
                                </div>
                            </div>
                            <!-- Kolom Kanan -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Tanggal Mulai</label>
                                    <input type="date" name="tanggal_mulai" class="form-control" value="<?= esc($periode['tanggal_mulai']) ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Tanggal Selesai</label>
                                    <input type="date" name="tanggal_selesai" class="form-control" value="<?= esc($periode['tanggal_selesai']) ?>">
                                </div>
                            </div>
                        </div>

                        <div class="text-end mt-3">
                            <button type="submit" class="btn btn-success btn-sm me-2"><i class="fas fa-save"></i> Update</button>
                            <a href="<?= base_url('periode') ?>" class="btn btn-secondary btn-sm"><i class="fas fa-arrow-left"></i> Batal</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</main>

</body>
</html>
