<!DOCTYPE html>
<html lang="en">

<head>
    <?= $this->include('layout/head') ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
</head>

<body>
<?= $this->include('layout/sidebar') ?>

<main id="main" class="main">
    <div class="pagetitle">
        <!-- Main Content -->
        <div class="container-fluid p-4">

            <!-- Topbar -->
            <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4">
                <div class="container-fluid d-flex justify-content-between align-items-center">
                    <h4 class="m-0 text-primary">Manajemen Periode</h4>
                    <div>
                    <?php if (session()->get('login')['role'] === 'admin'): ?>
                        <a href="<?= base_url('periode/create') ?>" class="btn btn-success btn-sm me-2">
                            <i class="fa fa-plus"></i> Tambah
                        </a>
                    <?php endif; ?>
                        <a href="<?= base_url('dashboard') ?>" class="btn btn-secondary btn-sm">
                            <i class="fa fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
            </nav>

            <!-- Flash Message (opsional) -->
            <?php if (session()->getFlashdata('success')) : ?>
                <div class="alert alert-success">
                    <?= session()->getFlashdata('success') ?>
                </div>
            <?php endif; ?>

            <!-- Card Data Guru -->
            <div class="card shadow">
                <div class="card-header" style="background-color: #5c8978;" >
                    <strong>Data Guru</strong>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped text-center">
                            <thead class="bg-light">
                                <tr>
                                    <th>No</th>
                                    <th>Nama Periode</th>
                                    <th>Tahun Ajaran</th>
                                    <th>Tanggal Mulai</th>
                                    <th>Tanggal Selesai</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($periode)) : ?>
                                    <tr>
                                        <td colspan="6" class="text-center">Tidak ada data periode.</td>
                                    </tr>
                                <?php else : ?>
                                    <?php foreach ($periode as $index => $p) : ?>
                                        <tr>
                                            <td><?= $index + 1 ?></td>
                                            <td><?= esc($p['nama_periode']) ?></td>
                                            <td><?= esc($p['tahun_ajaran']) ?></td>
                                            <td><?= esc($p['tanggal_mulai']) ?></td>
                                            <td><?= esc($p['tanggal_selesai']) ?></td>
                                            <td>
                                                <a href="<?= base_url('periode/edit/' . $p['id']) ?>" class="btn btn-warning btn-sm">
                                                    <i class="fa fa-edit"></i> Edit
                                                </a>
                                                <a href="<?= base_url('periode/delete/' . $p['id']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin ingin menghapus periode ini?')">
                                                    <i class="fa fa-trash"></i> Hapus
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                                
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</main>
</body>

</html>
