<!DOCTYPE html>
<html lang="en">

<head>
    <?= $this->include('layout/head') ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <style>
        
        .table-no-vertical {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }

        .table-no-vertical th,
        .table-no-vertical td {
            border: none;
            padding: 12px 16px;
            vertical-align: middle;
            color: #444;
        }

        .table-no-vertical tr {
            border-bottom: 1px solid #ddd;
        }

        .table-no-vertical tr:last-child {
            border-bottom: none;
        }

        .table-no-vertical th {
            width: 30%;
            font-weight: 600;
            color: #222;
            background-color: #f9f9f9;
        }

        /* Styling kotak foto */
        .profile-photo-box {
            width: 220px;
            height: 220px;
            border: 3px solid #5c8978;
            border-radius: 8px;
            box-shadow: 0 0 12px rgb(92 137 120 / 0.3);
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            margin-bottom: 1rem;
            background-color: white;
        }

        .profile-photo-box img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 6px;
        }

        /* Container utama card */
        .profile-card {
            max-width: 900px;
            margin: 2rem auto;
            box-shadow: 0 2px 12px rgb(0 0 0 / 0.1);
            border-radius: 10px;
            background-color: white;
            padding: 2rem;
        }

        /* Header kartu */
        .profile-card-header {
            background-color: #5c8978;
            color: white;
            padding: 1rem 2rem;
            border-radius: 10px 10px 0 0;
            font-size: 1.4rem;
            font-weight: 600;
            letter-spacing: 0.03em;
            margin-bottom: 2rem;
            text-align: center;
            user-select: none;
        }

        /* Tombol edit */
        .edit-btn {
            position: absolute;
            bottom: 20px;
            right: 20px;
        }

        /* Responsive adjustments */
        @media (max-width: 767.98px) {
            .profile-photo-box {
                width: 150px;
                height: 150px;
                margin: 0 auto 1.5rem;
            }
            .profile-card {
                padding: 1.5rem 1rem 3rem;
            }
            .edit-btn {
                position: static;
                display: block;
                margin: 1rem auto 0 auto;
                width: 120px;
                text-align: center;
            }
        }
    </style>
</head>

<body>
    <?= $this->include('layout/sidebar') ?>

    <main id="main" class="main">
        <div class="container">
            <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4 rounded">
                <div class="container-fluid d-flex justify-content-between align-items-center">
                    <h4 class="m-0 text-primary">Profil Saya</h4>
                    <a href="<?= base_url('dashboard') ?>" class="btn btn-secondary btn-sm">
                        <i class="fa fa-arrow-left"></i> Kembali
                    </a>
                </div>
            </nav>

            <!-- Flash Messages -->
            <?php if (session()->getFlashdata('success')) : ?>
                <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
            <?php endif; ?>

            <?php if (session()->getFlashdata('errors')) : ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php foreach (session()->getFlashdata('errors') as $error) : ?>
                            <li><?= esc($error) ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>

            <!-- Profil Card -->
            <div class="profile-card position-relative">

                <div class="profile-card-header">Informasi Profil</div>

                <div class="d-flex flex-column flex-md-row align-items-start gap-5">
                    <!-- Foto Profil -->
                    <div class="profile-photo-box">
                        <?php if (!empty($user['photo'])) : ?>
                            <img src="<?= base_url('uploads/photos/' . $user['photo']) ?>" alt="Foto Profil">
                        <?php else : ?>
                            <img src="<?= base_url('assets/img/default-profile.png') ?>" alt="Default Foto">
                        <?php endif; ?>
                    </div>

                    <!-- Informasi Profil dalam Tabel -->
                    <table class="table-no-vertical">
                        <tr>
                            <th>Nama</th>
                            <td><?= esc($user['nama']) ?></td>
                        </tr>
                        <tr>
                            <th>Username</th>
                            <td><?= esc($user['username']) ?></td>
                        </tr>
                        <tr>
                            <th>No HP</th>
                            <td><?= esc($user['no_hp']) ?></td>
                        </tr>
                        <tr>
                            <th>Email</th>
                            <td><?= esc($user['email']) ?></td>
                        </tr>
                        <tr>
                            <th>Agama</th>
                            <td><?= esc($user['agama']) ?></td>
                        </tr>
                        <tr>
                            <th>Tempat, Tanggal Lahir</th>
                            <td><?= esc($user['tempat_lahir']) ?>, <?= esc($user['tanggal_lahir']) ?></td>
                        </tr>
                        <tr>
                            <th>Jenis Kelamin</th>
                            <td><?= esc($user['jenis_kelamin']) ?></td>
                        </tr>
                        <tr>
                            <th>Alamat</th>
                            <td><?= esc($user['alamat']) ?></td>
                        </tr>
                    </table>
                </div>

                <!-- Tombol Edit -->
                <a href="<?= base_url('profile/create') ?>" class="btn btn-primary btn-sm edit-btn">
                    <i class="fa fa-edit"></i> Edit
                </a>
            </div>
        </div>
    </main>
</body>

</html>
