<?= $this->include('layout/head') ?>
<?= $this->include('layout/sidebar') ?>

<main id="main" class="main">
    <!-- Konten Evaluasi untuk Kepsek -->
    <div class="container-fluid p-4">
        <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4">
            <div class="container-fluid d-flex justify-content-between align-items-center">
                <h4 class="m-0 text-primary">Rekap Performa</h4>
                <div class="d-flex gap-2">
                    <select id="filterPeriode" class="form-select form-select-sm">
                        <option value="">-- Semua Periode --</option>
                        <?php foreach ($periodeList as $p): ?>
                            <option value="<?= esc($p) ?>"><?= esc($p) ?></option>
                        <?php endforeach; ?>
                    </select>
                    <a href="<?= base_url('dashboard') ?>" class="btn btn-secondary btn-sm">
                        <i class="fa fa-arrow-left"></i> Kembali
                    </a>
                </div>
            </div>
        </nav>

        <?php if (!empty($rekap)): ?>
            <?php foreach ($rekap as $item): ?>
                <?php
                    $labels = [];
                    $data = [];
                    if (!empty($item['guru'])) {
                        foreach ($item['guru'] as $guru) {
                            $labels[] = $guru['nama_guru'];
                            $data[] = (int)$guru['total_nilai'];
                        }
                    }
                    $periodeLabel = $item['periode']['nama_periode'] . ' ' . $item['periode']['tahun_ajaran'];
                    $chartId = 'rekapChart_' . md5($periodeLabel);
                ?>
                <div class="card shadow mb-4 rekap-card">
                    <div class="card-header text-white" style="background-color: #5c8978;">
                        <strong>Data Rekapan Evaluasi</strong>
                    </div>
                    <div class="card-body">
                        <h2 class="periode-title">Periode <?= esc($periodeLabel) ?></h2>
                        <div class="table-responsive">
                            <canvas id="<?= $chartId ?>" width="400" height="150"></canvas>
                        </div>
                    </div>
                </div>
                <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
                <script>
                    var ctx = document.getElementById('<?= $chartId ?>').getContext('2d');
                    new Chart(ctx, {
                        type: 'bar',
                        data: {
                            labels: <?= json_encode($labels) ?>,
                            datasets: [{
                                label: 'Nilai Performa',
                                data: <?= json_encode($data) ?>,
                                backgroundColor: 'rgba(92, 137, 120, 0.7)',
                                borderColor: 'rgba(92, 137, 120, 1)',
                                borderWidth: 1
                            }]
                        },
                        options: {
                            scales: {
                                y: {
                                    beginAtZero: true
                                }
                            }
                        }
                    });
                </script>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="alert alert-warning">Data tidak tersedia.</div>
        <?php endif; ?>
    </div>
</main>

<!-- Script Filter Dropdown -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const filterSelect = document.getElementById("filterPeriode");
        const cards = document.querySelectorAll(".rekap-card");

        filterSelect.addEventListener("change", function () {
            const selected = this.value.trim().toLowerCase();

            cards.forEach(card => {
                const title = card.querySelector(".periode-title").textContent.toLowerCase();
                if (selected === "") {
                    card.style.display = "block";
                } else {
                    card.style.display = title.includes(selected) ? "block" : "none";
                }
            });
        });
    });
</script>
