<!DOCTYPE html>
<html lang="en">

<head>
    <?= $this->include('layout/head') ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
</head>

<body>
<?= $this->include('layout/sidebar') ?>

<main id="main" class="main">
    <div class="pagetitle">
        <div class="container mt-4">
            <div class="card shadow">
                <div class="card-header text-white" style="background-color: #5c8978;">
                    <h5 class="mb-0">Form Edit Data Guru</h5>
                </div>
                <div class="card-body">
                    <form action="<?= base_url('users/update/' . $user['id']) ?>" method="post">
                        <div class="row">
                        <h3>Edit User</h3>
                        <form action="/users/update/<?= $user['id'] ?>" method="post">
                            <label>Nama</label>
                            <input type="text" name="nama" value="<?= esc($user['nama']) ?>" required><br>

                            <label>Username</label>
                            <input type="text" name="username" value="<?= esc($user['username']) ?>" required><br>

                            <label>Password</label>
                            <input type="password" name="password" placeholder="Kosongkan jika tidak diubah"><br>

                            <label>Role</label>
                            <select name="role" required>
                                <option value="admin" <?= $user['role'] === 'admin' ? 'selected' : '' ?>>Admin</option>
                                <option value="guru" <?= $user['role'] === 'guru' ? 'selected' : '' ?>>Guru</option>
                                <option value="kepsek" <?= $user['role'] === 'kepsek' ? 'selected' : '' ?>>Kepsek</option>
                            </select><br>
                        <div class="text-end mt-3">
                            <button type="submit" class="btn btn-success btn-sm me-2"><i class="fas fa-save"></i> Update</button>
                            <a href="<?= base_url('users') ?>" class="btn btn-secondary btn-sm"><i class="fas fa-arrow-left"></i> Batal</a>
                        </div>
                    </form>
